/** @type {AppTypes.Config} */
window.config = {
  routerBasename: '/dicom/',
  showStudyList: false,
  extensions: [],
  modes: [],
  customizationService: {},
  // below flag is for performance reasons, but it might not work for all servers
  showWarningMessageForCrossOrigin: true,
  showCPUFallbackMessage: true,
  showLoadingIndicator: true,
  strictZSpacingForVolumeViewport: true,
  defaultDataSourceName: 'dicomweb',
  disableEditing: true,
  groupEnabledModesFirst: true,
  disableConfirmationPrompts: true,
  maxNumRequests: {
    interaction: 100,
    thumbnail: 75,
    // Prefetch number is dependent on the http protocol. For http 2 or
    // above, the number of requests can be go a lot higher.
    prefetch: 25,
  },
  dataSources: [
    {
      namespace: '@ohif/extension-default.dataSourcesModule.dicomweb',
      sourceName: 'dicomweb',
      configuration: {
        friendlyName: 'Dcm4chee Server',
        name: 'Dcm4chee',
        wadoUriRoot: '/elvasoft/pacs/wado',
        qidoRoot: '/elvasoft/pacs/rs',
        wadoRoot: '/elvasoft/pacs/rs',
        qidoSupportsIncludeField: false,
        imageRendering: 'wadors',
        enableStudyLazyLoad: true,
        thumbnailRendering: 'wadors',
        dicomUploadEnabled: true,
        omitQuotationForMultipartRequest: true,
        requestOptions: {
          auth: 'admin:admin',
        },
        bulkDataURI: {
          enabled: true,
        },
        singlepart: 'pdf,video',
      },
    },
  ],
};
